const mysql = require("mysql2/promise");


const dbConfig = {
  host: "127.0.0.1",
  user: "root",
  password: "",
  database: "avasya_db",
  port: 3306
};

const pool = mysql.createPool(dbConfig);
(async () => {
  try {
    const connection = await pool.getConnection();
    console.log("\x1b[32m%s\x1b[0m", "✅ Connected to MySQL database successfully!");
    connection.release();
  } catch (err) {
    console.error("\x1b[31m%s\x1b[0m", `❌ Database connection failed: ${err.message}`);
    process.exit(1);
  }
})();